

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Cities')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first"></div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="row">
            <form class="create-form" action="<?php echo e(route('city.create')); ?>" method="POST" data-parsley-validate enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header"><?php echo e(__("Add City")); ?></div>
                        <div class="card-body mt-3">
                            <div class="row">
                                <div class="col-md-6 form-group">
                                    <label for="country" class="mandatory form-label"><?php echo e(__("Country")); ?></label>
                                    <select name="country_id" id="country" class="form-control form-select" data-placeholder="<?php echo e(__("Select Country")); ?>">
                                        <option value="">Select Country</option>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                                <div class="col-md-6 form-group">
                                    <label for="state" class="mandatory form-label"><?php echo e(__("State")); ?></label>
                                    <select name="state_id" id="state" class="form-control form-select" data-placeholder="<?php echo e(__("Select State")); ?>">
                                        <option value="">Select State</option>
                                    </select>
                                </div>
                            </div>
                            <div id="city-container" >
                                <div class="row">
                                    <div class="form-group col-md-4 col-sm-12">
                                        <label for="name" class="mandatory form-label mt-2">City Name</label>
                                        <div class="d-flex mb-2">
                                            <input type="text" name="name[]" class="form-control me-2" placeholder="Enter City name">

                                        </div>
                                    </div>
                                    <div class="form-group col-md-4 col-sm-12">
                                        <label for="latitude" class="mandatory form-label mt-2">Latitude</label>
                                        <div class="d-flex mb-2">
                                            <input type="text" name="latitude[]" class="form-control me-2" placeholder="Enter Latitude">
                                    </div>
                                    </div>
                                     <div class="form-group col-md-4 col-sm-12">
                                    <label for="longitude" class="mandatory form-label mt-2">Longitude</label>
                                    <div class="d-flex mb-2">
                                        <input type="text" name="longitude[]" class="form-control me-2" placeholder="Enter Longitude">
                                         <button type="button" class="btn btn-secondary add-city-button">+</button>
                                    </div>
                                    </div>
                                </div>


                            </div>
                            <div class="col-md-12 m-2 text-end">
                                <input type="submit" class="btn btn-primary" value="<?php echo e(__("Create")); ?>">
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>

        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div id="filters">
                            <div class="row">
                                <div class="col-12 col-md-4">
                                    <label for="filter_country"><?php echo e(__("Country")); ?></label>
                                    <select class="form-control bootstrap-table-filter-control-country_name" id="filter_country">
                                        <option value=""><?php echo e(__("All")); ?></option>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-12 col-md-4">
                                    <label for="filter_state"><?php echo e(__("State")); ?></label>
                                    <select class="form-control bootstrap-table-filter-control-state_name" id="filter_state">
                                        <option value=""><?php echo e(__("All")); ?></option>
                                        <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>

                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <table class="table-borderless table-striped" aria-describedby="mydesc" id="table_list"
                                       data-toggle="table" data-url="<?php echo e(route('cities.show',1)); ?>" data-click-to-select="true"
                                       data-side-pagination="server" data-pagination="true"
                                       data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true"
                                       data-show-columns="true" data-show-refresh="true" data-fixed-columns="true"
                                       data-fixed-number="1" data-fixed-right-number="1" data-trim-on-search="false"
                                       data-responsive="true" data-sort-name="id" data-sort-order="desc"
                                       data-pagination-successively-size="3" data-table="cities" data-status-column="deleted_at"
                                       data-escape="true"
                                       data-filter-control="true"
                                       data-toolbar="#filters"
                                       data-filter-control-container="#filters"
                                       data-show-export="true" data-export-options='{"fileName": "city-list","ignoreColumn": ["operate"]}' data-export-types="['pdf','json', 'xml', 'csv', 'txt', 'sql', 'doc', 'excel']"
                                       data-mobile-responsive="true">
                                    <thead class="thead-dark">
                                    <tr>
                                        <th scope="col" data-field="id" data-sortable="true"><?php echo e(__('ID')); ?></th>
                                        <th scope="col" data-field="name" data-sortable="true"><?php echo e(__('Name')); ?></th>
                                        <th scope="col" data-field="country_name" data-sortable="true" data-filter-name="country_id" data-filter-control="select" data-filter-data=""><?php echo e(__('Country Name')); ?></th>
                                        <th scope="col" data-field="state_name" data-sortable="true" data-filter-name="state_id" data-filter-control="select" data-filter-data=""><?php echo e(__('State Name')); ?></th>
                                        <th scope="col" data-field="country.emoji"><?php echo e(__('Flag')); ?></th>
                                        <th scope="col" data-field="operate" data-sortable="false" data-escape="false" data-events="cityEvents"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('city-update')): ?>
                <!-- EDIT MODEL MODEL -->
                    <div id="editModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title" id="myModalLabel1"><?php echo e(__('Edit City')); ?></h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body">
                                    <form id="edit-form" class="edit-form" action="" method="POST" enctype="multipart/form-data">
                                        <?php echo csrf_field(); ?>
                                        <div class="row">
                                            <div class="col-md-6 form-group">
                                                <label for="country" class="mandatory form-label"><?php echo e(__("Country")); ?></label>
                                                <select name="country_id" id="edit_country" class="form-control country form-select" data-placeholder="<?php echo e(__("Select Country")); ?>">
                                                    <option value="">Select Country</option>
                                                    <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>

                                            <div class="col-md-6 form-group">
                                                <label for="state" class="mandatory form-label"><?php echo e(__("State")); ?></label>
                                                <select name="state_id" id="edit_state" class="form-control form-select" data-placeholder="<?php echo e(__("Select State")); ?>">
                                                    <?php $__currentLoopData = $states; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $state): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($state->id); ?>"><?php echo e($state->name); ?></option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                        <div id="city-container" >
                                            <div class="row">
                                                <div class="form-group col-md-4 col-sm-12">
                                                    <label for="name" class="mandatory form-label mt-2">City Name</label>
                                                    <div class="d-flex mb-2">
                                                        <input type="text" name="name" class="form-control me-2" id="edit_name" placeholder="Enter City name">

                                                    </div>
                                                </div>
                                                <div class="form-group col-md-4 col-sm-12">
                                                    <label for="latitude" class="mandatory form-label mt-2">Latitude</label>
                                                    <div class="d-flex mb-2">
                                                        <input type="text" name="latitude" id="edit_latitude" class="form-control me-2" placeholder="Enter Latitude">
                                                </div>
                                                </div>
                                                 <div class="form-group col-md-4 col-sm-12">
                                                <label for="longitude" class="mandatory form-label mt-2">Longitude</label>
                                                <div class="d-flex mb-2">
                                                    <input type="text" name="longitude"  id="edit_longitude" class="form-control me-2" placeholder="Enter Longitude">
                                                </div>
                                            </div>
                                        <div class="modal-footer">
                                            <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(__('Save')); ?></button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/places/city.blade.php ENDPATH**/ ?>