

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Languages')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first"></div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="row">
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <div class="divider">
                            <div class="divider-text">
                                <h4><?php echo e(__('Add Language')); ?></h4>
                            </div>
                        </div>
                    </div>
                    <div class="card-content">
                        <div class="card-body">
                            <div class="row form-group">
                                <div class="col-sm-12 col-md-12 form-group">
                                    <?php echo Form::open(['url' => route('language.store'), 'files' => true, 'data-parsley-validate','class'=>'create-form']); ?>

                                    <div class="row">
                                        <div class="col-sm-12 col-md-12 form-group mandatory ">
                                            <?php echo e(Form::label('Language Name', __('Language Name'), ['class' => 'form-label text-center'])); ?>

                                            <?php echo e(Form::text('name', '', ['class' => 'form-control', 'placeholder' => __('Language Name'), 'data-parsley-required' => 'true'])); ?>

                                        </div>

                                        <div class="col-sm-12 col-md-12 form-group mandatory ">
                                            <?php echo e(Form::label('Language Name', __('Language Name'). " (".__("in English").")", ['class' => 'form-label text-center'])); ?>

                                            <?php echo e(Form::text('name_in_english', '', ['class' => 'form-control', 'placeholder' => __('Language Name')." (".__("in English").")", 'data-parsley-required' => 'true'])); ?>

                                        </div>

                                        <div class="col-sm-12 col-md-12 form-group mandatory ">
                                            <?php echo e(Form::label('Language Code', __('Language Code'), ['class' => 'form-label text-center'])); ?>

                                            <?php echo e(Form::text('code', '', ['class' => 'form-control', 'placeholder' => __('Language Code'), 'data-parsley-required' => 'true'])); ?>

                                        </div>
                                        <div class="col-sm-12 col-md-12 form-group mandatory ">
                                            <?php echo e(Form::label('Country Code', __('Country Code'), ['class' => 'form-label text-center'])); ?>

                                            <?php echo e(Form::text('country_code', '', ['class' => 'form-control', 'placeholder' => __('Country Code'), 'data-parsley-required' => 'true'])); ?>

                                        </div>
                                        <div class="col-sm-12 col-md-12 form-group mandatory">
                                            <label class="form-label "><?php echo e(__('Image')); ?></label>
                                            <div class="">
                                                <input class="filepond" type="file" name="image" id="favicon_icon">
                                            </div>
                                        </div>
                                        <div class="col-sm-1 col-md-12">
                                            <?php echo e(Form::label('file', __('RTL'), ['class' => 'col-form-label text-center'])); ?>

                                            <div class="form-check form-switch col-12" style='padding-right:12.5rem;'>
                                                <?php echo e(Form::checkbox('rtl', '', false, ['class' => 'form-check-input','id'=>'rtl'])); ?>

                                            </div>
                                        </div>
                                    </div>
                                    
                                        <div class="col-sm-12 d-flex justify-content-end mt-3">
                                            <?php echo e(Form::submit(__('Save'), ['class' => 'btn btn-primary me-1 mb-1'])); ?>

                                        </div>

                                </div>
                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-8">
                <div class="card">
                    <div class="card-body">
                        <div class="row">
                            <div class="col-12">
                                <table class="table-light table-striped" aria-describedby="mydesc" id="table_list"
                                       data-toggle="table" data-url="<?php echo e(route('language.show',1)); ?>" data-click-to-select="true"
                                       data-side-pagination="server" data-pagination="true"
                                       data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true"
                                       data-toolbar="#toolbar" data-show-columns="true" data-show-refresh="true"
                                       data-fixed-columns="true" data-fixed-number="1" data-fixed-right-number="1"
                                       data-trim-on-search="false" data-responsive="true" data-sort-name="id"
                                       data-sort-order="desc" data-pagination-successively-size="3"
                                       data-escape="true"
                                       data-query-params="queryParams" data-mobile-responsive="true">
                                    <thead>
                                    <tr>
                                        <th scope="col" data-field="id" data-sortable="true"><?php echo e(__('ID')); ?></th>
                                        <th scope="col" data-field="name" data-sortable="false"><?php echo e(__('Name')); ?></th>
                                        <th scope="col" data-field="name_in_english" data-sortable="false"><?php echo e(__('Name'). " (".__("in English").")"); ?></th>
                                        <th scope="col" data-field="code" data-sortable="true"><?php echo e(__('Language Code')); ?></th>
                                        <th scope="col" data-field="country_code" data-sortable="true"><?php echo e(__('Country Code')); ?></th>
                                        
                                        <th scope="col" data-field="image" data-sortable="false" data-formatter="imageFormatter"><?php echo e(__('Image')); ?></th>
                                        <th scope="col" data-field="operate" data-escape="false" data-sortable="false" data-events="languageEvents"><?php echo e(__('Action')); ?></th>

                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- EDIT MODEL MODEL -->
    <div id="editModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
        <div class="modal-dialog">
            <form action="#" class="form-horizontal" id="edit-form" enctype="multipart/form-data" method="POST" data-parsley-validate>
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="myModalLabel1"><?php echo e(__('Edit Language')); ?></h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-sm-12">
                                <div class="col-md-12 col-12">
                                    <div class="form-group mandatory">
                                        <label for="edit_name" class="form-label col-12"><?php echo e(__('Language Name')); ?></label>
                                        <input type="text" id="edit_name" class="form-control col-12" placeholder="<?php echo e(__("Name")); ?>" name="name" data-parsley-required="true">
                                    </div>
                                </div>
                            </div>

                            <div class="col-sm-12">
                                <div class="col-md-12 col-12">
                                    <div class="form-group mandatory">
                                        <label for="edit_name_in_english" class="form-label col-12"><?php echo e(__('Language Name')); ?>(<?php echo e(__("in English")); ?>)</label>
                                        <input type="text" id="edit_name_in_english" class="form-control col-12" placeholder="<?php echo e(__("Name")); ?>" name="name_in_english" data-parsley-required="true">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="col-md-12 col-12">
                                    <div class="form-group mandatory">
                                        <label for="edit_code" class="form-label col-12"><?php echo e(__('Language Code')); ?></label>
                                        <input type="text" id="edit_code" class="form-control col-12" placeholder="<?php echo e(__("Language Code")); ?>" name="code" data-parsley-required="true">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12">
                                <div class="col-md-12 col-12">
                                    <div class="form-group mandatory">
                                        <label for="edit_code" class="form-label col-12"><?php echo e(__('Country Code')); ?></label>
                                        <input type="text" id="edit_country_code" class="form-control col-12" placeholder="<?php echo e(__("Country Code")); ?>" name="country_code" data-parsley-required="true">
                                    </div>
                                </div>
                            </div>
                            <div class="col-sm-12 col-md-12 form-group">
                                <label class="col-form-label "><?php echo e(__('Image')); ?></label>
                                <div class="">
                                    <input class="filepond" type="file" name="image" id="edit_image">
                                </div>
                            </div>
                            
                            <div class="col-sm-12">
                                <div class="col-md-12 col-12">
                                    <div class="form-group form-check form-switch">
                                        <label for="edit_rtl" class="form-label col-12"><?php echo e(__('RTL')); ?></label>
                                        <input type="hidden" value="0" name="rtl" id="edit_rtl">
                                        <input type="checkbox" class="form-check-input status-switch" id="edit_rtl_switch" aria-label="edit_rtl">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                        <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(__('Save')); ?></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/settings/language.blade.php ENDPATH**/ ?>