

<?php $__env->startSection('title'); ?>
    <?php echo e(__("Area")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('area-create')): ?>
            <div class="row">
                <form class="create-form" action="<?php echo e(route('area.create')); ?>" method="POST" data-parsley-validate enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <div class="col-md-12">
                        <div class="card">
                            <div class="card-header"><?php echo e(__("Add Area")); ?></div>
                            <div class="card-body mt-3">
                                <div class="row">
                                    <div class="col-md-4 form-group">
                                        <label for="country" class="mandatory form-label">Country:</label>
                                        <select name="country_id" id="country" class="form-control form-select" data-placeholder="<?php echo e(__("Select Country")); ?>">
                                            <option value="">Select Country</option>
                                            <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="state" class="mandatory form-label">State:</label>
                                        <select name="state_id" id="state" class="form-control form-select" data-placeholder="<?php echo e(__("Select State")); ?>">
                                            <option value="">Select State</option>
                                        </select>
                                    </div>

                                    <div class="col-md-4 form-group">
                                        <label for="city" class="mandatory form-label">City:</label>
                                        <select name="city_id" id="city" class="form-control form-select" data-placeholder="<?php echo e(__("Select City")); ?>">
                                            <option value="">Select City</option>
                                        </select>
                                    </div>
                                    <div id="areas-container" class="col-md-4 form-group">

                                        <label for="name" class="mandatory form-label mt-2"><?php echo e(__('Area Name')); ?></label>
                                        <div class="d-flex">
                                            <input type="text" id="name" name="name[]" class="form-control me-2 " placeholder="Enter Area name">
                                            <button type="button" id="add-area-button" class="btn btn-secondary">+</button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-12 m-2 text-end">
                                    <input type="submit" class="btn btn-primary" value="<?php echo e(__("Create")); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        <?php endif; ?>
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-12">
                        <div id="filters">
                            <div class="row">
                                <div class="col-12 col-md-4">
                                    <label for="filter_country"><?php echo e(__("Country")); ?></label>
                                    <select class="form-control bootstrap-table-filter-control-country.name" id="filter_country">
                                        <option value=""><?php echo e(__("All")); ?></option>
                                        <?php $__currentLoopData = $countries; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $country): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($country->id); ?>"><?php echo e($country->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <div class="col-12 col-md-4">
                                    <label for="filter_state"><?php echo e(__("State")); ?></label>
                                    <select class="form-control bootstrap-table-filter-control-state.name" id="filter_state">
                                        <option value=""><?php echo e(__("All")); ?></option>
                                    </select>
                                </div>
                                <div class="col-12 col-md-4">
                                    <label for="filter_city"><?php echo e(__("City")); ?></label>
                                    <select name="city_id" class="form-control bootstrap-table-filter-control-city.name" id="filter_city">
                                        <option value=""><?php echo e(__("All")); ?></option>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-12">
                                <table class="table-light table-striped" aria-describedby="mydesc" id="table_list"
                                       data-toggle="table" data-url="<?php echo e(route('area.show',1)); ?>" data-click-to-select="true"
                                       data-side-pagination="server" data-pagination="true"
                                       data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true"
                                       data-show-columns="true" data-show-refresh="true"
                                       data-fixed-columns="true" data-fixed-number="1" data-fixed-right-number="1"
                                       data-trim-on-search="false" data-responsive="true" data-sort-name="id"
                                       data-sort-order="desc" data-pagination-successively-size="3"
                                       data-escape="true" data-mobile-responsive="true"
                                       data-filter-control="true"
                                       data-toolbar="#filters"
                                       data-filter-control-container="#filters">
                                    <thead>
                                    <tr>
                                        <th scope="col" data-field="id" data-sortable="true"><?php echo e(__('ID')); ?></th>
                                        <th scope="col" data-field="name" data-sortable="false"><?php echo e('Name'); ?></th>
                                        <th scope="col" data-field="country.name" data-sortable="false" data-filter-name="country_id" data-filter-control="select" data-filter-data=""><?php echo e(__('Country')); ?></th>
                                        <th scope="col" data-field="state.name" data-sortable="false" data-filter-name="state_id" data-filter-control="select" data-filter-data=""><?php echo e('State'); ?></th>
                                        <th scope="col" data-field="city.name" data-sortable="false" data-filter-name="city_id" data-filter-control="select" data-filter-data=""><?php echo e('City'); ?></th>
                                        <th scope="col" data-field="operate" data-sortable="false" data-escape="false" data-events="areaEvents"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('area-update')): ?>
        <!-- EDIT MODEL MODEL -->
            <div id="editModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel1"><?php echo e(__('Edit Area')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form id="edit-form" class="edit-form" action="" method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="edit_name" class="mandatory form-label"><?php echo e(__('Name')); ?></label>
                                        <input type="text" name="name" id="edit_name" class="form-control" data-parsley-required="true">
                                    </div>
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(__('Save')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/places/area.blade.php ENDPATH**/ ?>