
<?php $__env->startSection('title'); ?>
    <?php echo e(__("Create Categories")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="buttons">
            <a class="btn btn-primary" href="<?php echo e(route('category.index')); ?>">< <?php echo e(__("Back to All Categories")); ?> </a>
        </div>
        <div class="row">
            <form action="<?php echo e(route('category.store')); ?>" method="POST" data-parsley-validate enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header"><?php echo e(__("Add Category")); ?></div>

                        <div class="card-body mt-3">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="category_name" class="mandatory form-label"><?php echo e(__('Name')); ?></label>
                                        <input type="text" name="name" id="category_name" class="form-control" data-parsley-required="true">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="category_slug" class="form-label"><?php echo e(__('Slug')); ?> <small><?php echo e(__('(English Only)')); ?></small></label>
                                        <input type="text" name="slug" id="category_slug" class="form-control" data-parsley-required="true">
                                    </div>
                                </div>

                                <div class="col-md-6">
                                    <div class="col-md-12 form-group">
                                        <label for="p_category" class="form-label"><?php echo e(__('Parent Category')); ?></label>
                                        <select name="parent_category_id" id="p_category" class="form-select form-control select2" data-placeholder="<?php echo e(__('Select Category')); ?>">
                                            <option value=""><?php echo e(__('Select a Category')); ?></option>
                                            <?php echo $__env->make('category.dropdowntree', ['categories' => $categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                        </select>
                                    </div>
                                </div>
                                

                                <div class="col-md-6">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="Field Name" class="mandatory form-label"><?php echo e(__('Image')); ?></label>
                                        <input type="file" name="image" id="image" class="form-control" data-parsley-required="true" accept=".jpg,.jpeg,.png">
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <label for="description" class="mandatory form-label"><?php echo e(__('Description')); ?></label>
                                    <textarea name="description" id="description" class="form-control" cols="10" rows="5"></textarea>
                                    <div class="form-check form-switch mt-3">
                                        <input type="hidden" name="status" id="status" value="0">
                                        <input class="form-check-input status-switch" type="checkbox" role="switch" aria-label="status"><?php echo e(__('Active')); ?>

                                        <label class="form-check-label" for="status"></label>
                                    </div>
                                </div>


                                <?php if($languages->isNotEmpty()): ?>
                                <div class="row">
                                    <hr>
                                    <h5><?php echo e(__("Translation") . " " . __("Optional")); ?></h5>

                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-6 form-group">
                                            <label for="name_<?php echo e($language->id); ?>" class="form-label"><?php echo e(($key + 1) . ". " . $language->name); ?>:</label>
                                            <input name="translations[<?php echo e($language->id); ?>]" id="name_<?php echo e($language->id); ?>" class="form-control" value="">
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-12 text-end">
                        <input type="submit" class="btn btn-primary" value="<?php echo e(__("Save and Back")); ?>">
                    </div>
                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>



<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/category/create.blade.php ENDPATH**/ ?>