

<?php $__env->startSection('title'); ?>
    <?php echo e(__("Custom Fields")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <form action="<?php echo e(route('custom-fields.store')); ?>" method="POST" class="create-form" data-success-function="afterCustomFieldCreationSuccess" data-parsley-validate enctype="multipart/form-data">
            <?php echo csrf_field(); ?>
            <div class="row">
                <div class="col-md-6 col-sm-12">
                    <div class="card">
                        <div class="card-header"><?php echo e(__("Create Custom Field")); ?></div>
                        <div class="card-body mt-2">
                            <div class="row">
                                <div class="col-md-12">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="name" class="mandatory form-label"><?php echo e(__('Field Name')); ?></label>
                                        <input type="text" name="name" id="name" class="form-control" data-parsley-required="true">
                                    </div>
                                </div>

                                <div class="col-md-12 form-group mandatory">
                                    <label for="type" class="mandatory form-label"><?php echo e(__('Field Type')); ?></label>
                                    <select name="type" class="form-select form-control" id="type" data-parsley-required="true">
                                        <option value="number"><?php echo e(__("Number Input")); ?></option>
                                        <option value="textbox"><?php echo e(__("Text Input")); ?></option>
                                        <option value="fileinput"><?php echo e(__("File Input")); ?></option>
                                        <option value="radio"><?php echo e(__("Radio")); ?></option>
                                        <option value="dropdown"><?php echo e(__("Dropdown")); ?></option>
                                        <option value="checkbox"><?php echo e(__("Checkboxes")); ?></option>
                                    </select>
                                </div>

                                <div class="col-md-12" id="field-values-div" style="display: none;">
                                    <label for="values" class="form-label"><?php echo e(__('Field Values')); ?></label>
                                    <div class="form-group">
                                        <select id="values" name="values[]" data-tags="true" data-token-separators="[',']" data-placeholder="<?php echo e(__("Select an option")); ?>" data-allow-clear="true" class="select2 w-100 full-width-select2" multiple="multiple" data-parsley-required="true"></select>
                                        <div class="input_hint"><?php echo e(__("This will be applied only for")); ?>:
                                            <text class="highlighted_text"> <?php echo e(__("Checkboxes").",".__("Radio")); ?></text>
                                            <?php echo e(__("and")); ?>

                                            <text class="highlighted_text"><?php echo e(__("Dropdown")); ?></text>
                                            .
                                        </div>
                                    </div>
                                </div>

                                <div class="col-md-6 form-group min-max-fields">
                                    <label for="min_length" class=" form-label"><?php echo e(__('Field Length (Min)')); ?></label>
                                    <input type="number" name="min_length" id="min_length" class="form-control" min="1">
                                    <div class="input_hint"> <?php echo e(__("This will be applied only for")); ?>:
                                        <text class="highlighted_text"><?php echo e(__("text").",".__("number")); ?> </text>
                                        <?php echo e(__("and")); ?>

                                        <text class="highlighted_text"><?php echo e(__("textarea")); ?></text>
                                        .
                                    </div>
                                </div>
                                <div class="col-md-6 form-group min-max-fields">
                                    <label for="max_length" class=" form-label"><?php echo e(__('Field Length (Max)')); ?></label>
                                    <input type="number" name="max_length" id="max_length" class="form-control" min="1">
                                    <div class="input_hint"> <?php echo e(__("This will be applied only for")); ?>:
                                        <text class="highlighted_text"><?php echo e(__("text").",".__("number")); ?>

                                        </text>
                                        <?php echo e(__("and")); ?>

                                        <text class="highlighted_text"><?php echo e(__("textarea")); ?></text>
                                        .
                                    </div>
                                </div>

                                <div class="col-md-12">
                                    <div class="col-md-12 form-group mandatory">
                                        <label for="image" class="form-label"><?php echo e(__('Icon ')); ?></label>
                                        <input type="file" name="image" id="image" class="form-control" data-parsley-required="true" accept=" .jpg, .jpeg, .png, .svg">
                                        <?php echo e(__("(use 256 x 256 size for better view)")); ?>

                                        <div class="img_error" style="color:#DC3545;"></div>
                                    </div>
                                </div>

                            </div>
                            <div class="row">
                                <div class="col-md-6 form-group mandatory">
                                    <div class="form-check form-switch  ">
                                        <input type="hidden" name="required" id="required" value="0">
                                        <input class="form-check-input status-switch" type="checkbox" role="switch" aria-label="required"><?php echo e(__('Required')); ?>

                                        <label class="form-check-label" for="required"></label>
                                    </div>
                                </div>
                                <div class="col-md-6 form-group mandatory">
                                    <div class="form-check form-switch  ">
                                        <input type="hidden" name="status" id="status" value="0">
                                        <input class="form-check-input status-switch" type="checkbox" role="switch" aria-label="status"><?php echo e(__('Active')); ?>

                                        <label class="form-check-label" for="status"></label>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php if($cat_id == 0): ?>
                    <div class="col-md-6 col-sm-12">
                        <div class="card">
                            <div class="card-header"><?php echo e(__("Category")); ?></div>
                            <div class="card-body mt-2">
                                <div class="sub_category_lit">
                                    <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="category">
                                            <div class="category-header">
                                                <label>
                                                    <input type="checkbox" name="selected_categories[]" value="<?php echo e($category->id); ?>"> <?php echo e($category->name); ?>

                                                </label>
                                                <?php if(!empty($category->subcategories)): ?>
                                                    <i style='font-size:24px' class='fas toggle-button'>&#xf0da;</i>
                                                <?php endif; ?>
                                            </div>
                                            <div class="subcategories" style="display: none;">
                                                <?php if(!empty($category->subcategories)): ?>
                                                    <?php echo $__env->make('category.treeview', ['categories' => $category->subcategories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                                <?php endif; ?>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <input type="hidden" name="selected_categories[]" value="<?php echo e($cat_id); ?>">
                <?php endif; ?>
                <div class="col-md-12 text-end">
                    <input type="submit" class="btn btn-primary" value="<?php echo e(__("Save and Back")); ?>">
                </div>
            </div>
        </form>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
      function afterCustomFieldCreationSuccess() {
    setTimeout(function () {
        window.location.href = "<?php echo e(route('custom-fields.index')); ?>";
    }, 1000)
}
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/custom-fields/create.blade.php ENDPATH**/ ?>