

<?php $__env->startSection('title'); ?>
    <?php echo e(__("Custom Fields")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="buttons">
            <a class="btn btn-primary" href="<?php echo e(url('custom-fields')); ?>">< <?php echo e(__("Back to Custom Fields")); ?> </a>
            <?php if(in_array($custom_field->type,['radio','checkbox','dropdown'])): ?>
                <a class="btn btn-primary" data-bs-toggle="modal" data-bs-target='#addModal'>+ <?php echo e(__("Add Options")); ?></a>
            <?php endif; ?>
        </div>
        <form action="<?php echo e(route('custom-fields.update', $custom_field->id)); ?>" class="edit-form" data-success-function="afterCustomFieldUpdate" method="POST" data-parsley-validate enctype="multipart/form-data">
            <?php echo method_field('PUT'); ?>
            <?php echo csrf_field(); ?>
            <div class="row">

                <div class="col-md-6 col-sm-12">
                    <div class="card">
                        <div class="card-header"><?php echo e(__("Create Custom Field")); ?></div>
                        <div class="card-body mt-3">
                            <div class="row">
                                <div class="col-md-12 form-group mandatory">
                                    <label for="name" class="mandatory form-label"><?php echo e(__('Field Name')); ?></label>
                                    <input type="text" name="name" id="name" class="form-control" data-parsley-required="true" value="<?php echo e($custom_field->name); ?>">
                                </div>

                                <div class="col-md-12 form-group mandatory">
                                    <label for="type" class="mandatory form-label"><?php echo e(__('Field Type')); ?></label>
                                    <select name="type" id="type" class="form-select form-control">
                                        <option value="<?php echo e($custom_field->type); ?>" selected><?php echo e(ucfirst($custom_field->type)); ?></option>
                                    </select>
                                </div>

                                <?php if(in_array($custom_field->type,['radio','checkbox','dropdown'])): ?>
                                    <div class="col-md-12">
                                        <label for="values" class="form-label"><?php echo e(__('Field Values')); ?></label>
                                        <div class="form-group">
                                            <select id="values" name="values[]" data-tags="true" data-token-separators="[',']" data-placeholder="<?php echo e(__("Select an option")); ?>" data-allow-clear="true" class="select2 col-12 w-100" multiple="multiple">
                                                <?php $__currentLoopData = $custom_field->values; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <option value="<?php echo e($value); ?>" selected><?php echo e($value); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                            <div class="input_hint"><?php echo e(__("This will be applied only for")); ?>:
                                                <text class="highlighted_text"><?php echo e(__("Checkboxes").",".__("Radio")); ?></text>
                                                and
                                                <text class="highlighted_text"> <?php echo e(__("Dropdown")); ?></text>
                                                .
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <?php if(in_array($custom_field->type,['textbox','fileinput','number'])): ?>
                                    <div class="col-md-6 form-group ">
                                        <label for="min_length" class=" form-label"><?php echo e(__('Field Length (Min)')); ?></label>
                                        <input type="text" name="min_length" id="min_length" class="form-control" value="<?php echo e($custom_field->min_length); ?>">
                                        <div class="input_hint">  <?php echo e(__("This will be applied only for")); ?>:
                                            <text class="highlighted_text"><?php echo e(__("text").",".__("number")); ?></text>
                                            <?php echo e(__("and")); ?>

                                            <text class="highlighted_text"> <?php echo e(__("textarea")); ?></text>
                                            .
                                        </div>
                                    </div>
                                    <div class="col-md-6 form-group ">
                                        <label for="max_length" class=" form-label"><?php echo e(__('Field Length (Max)')); ?></label>
                                        <input type="text" name="max_length" id="max_length" class="form-control" value="<?php echo e($custom_field->max_length); ?>">
                                        <div class="input_hint"> <?php echo e(__("This will be applied only for")); ?>:
                                            <text class="highlighted_text"><?php echo e(__("text").",".__("number")); ?></text>
                                            <?php echo e(__("and")); ?>

                                            <text class="highlighted_text"> <?php echo e(__("textarea")); ?></text>
                                            .
                                        </div>
                                    </div>
                                <?php endif; ?>

                                <div class="col-md-12">
                                    <div class="col-md-12 form-group">
                                        <label for="image" class="form-label"><?php echo e(__('Image')); ?></label>
                                        <input type="file" name="image" id="image" class="form-control" accept=" .jpg, .jpeg, .png, .svg">
                                        <small><?php echo e(__("(use 256 x 256 size for better view)")); ?>}</small>
                                    </div>
                                    <div class="field_img mt-2">
                                        <img src="<?php echo e(empty($custom_field->image) ? asset('assets/img_placeholder.jpeg') : $custom_field->image); ?>" alt="" id="blah" class="preview-image img w-25">
                                    </div>
                                </div>

                                <div class="row mt-3">
                                    <div class="col-md-6 form-group mandatory">
                                        <div class="form-check form-switch  ">
                                            <input type="hidden" name="required" id="required" value="<?php echo e($custom_field->required ? '1' : '0'); ?>">
                                            <input class="form-check-input status-switch" type="checkbox" role="switch" aria-label="required" <?php echo e($custom_field->required ? 'checked' : ''); ?>><?php echo e(__('Required')); ?>

                                            <label class="form-check-label" for="required"></label>
                                        </div>
                                    </div>
                                    <div class="col-md-6 form-group mandatory">
                                        <div class="form-check form-switch  ">
                                            <input type="hidden" name="status" id="status" value="<?php echo e($custom_field->status ? '1' : '0'); ?>">
                                            <input class="form-check-input status-switch" type="checkbox" role="switch" aria-label="status" <?php echo e($custom_field->status ? 'checked' : ''); ?>><?php echo e(__('Active')); ?>

                                            <label class="form-check-label" for="status"></label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-6 col-sm-12">
                    <div class="card">
                        <div class="card-header"><?php echo e(__("Category")); ?></div>
                        <div class="card-body mt-2">
                            <div class="sub_category_lit">
                                <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="category">
                                        <div class="category-header">
                                            <label>
                                                <input type="checkbox" name="selected_categories[]" value="<?php echo e($category->id); ?>" <?php echo e(in_array($category->id,$selected_categories) ? "checked" : ""); ?>> <?php echo e($category->name); ?>

                                            </label>
                                            <?php if(!empty($category->subcategories)): ?>
                                                <i style='font-size:24px' class='fas toggle-button'>&#xf0da;</i>
                                            <?php endif; ?>
                                        </div>
                                        <div class="subcategories" style="display: none;">
                                            <?php if(!empty($category->subcategories)): ?>
                                                <?php echo $__env->make('category.treeview', ['categories' => $category->subcategories,'selected_categories' => $selected_categories], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-md-12 text-end mb-3">
                    <input type="submit" class="btn btn-primary" value="<?php echo e(__("Save and Back")); ?>">
                </div>
            </div>
        </form>
        <?php if(in_array($custom_field->type,['radio','checkbox','dropdown'])): ?>
            <div class="col-md-12 col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <table class="table table-borderless table-striped" id="table_list"
                               data-toggle="table" data-url="<?php echo e(route('custom-fields.value.show', $custom_field->id)); ?>"
                               data-click-to-select="true"
                               data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true" data-search-align="right"
                               data-toolbar="#toolbar" data-show-columns="true" data-show-refresh="true"
                               data-trim-on-search="false" data-responsive="true" data-sort-name="id"
                               data-escape="true"
                               data-sort-order="desc" data-query-params="queryParams"
                               data-table="custom_fields" data-use-row-attr-func="true" data-mobile-responsive="true">
                            <thead class="thead-dark">
                            <tr>
                                <th scope="col" data-field="id" data-align="center" data-sortable="true"><?php echo e(__('ID')); ?></th>
                                <th scope="col" data-field="value" data-align="center" data-sortable="true"><?php echo e(__('Value')); ?></th>
                                <th scope="col" data-field="operate"data-escape="false" data-align="center" data-sortable="false" data-events="customFieldValueEvents"><?php echo e(__('Action')); ?></th>
                            </tr>
                            </thead>
                        </table>
                    </div>
                </div>
            </div>
        <?php endif; ?>
        
        <?php if(in_array($custom_field->type,['radio','checkbox','dropdown'])): ?>
            <div id="addModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1"
                 aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel1"><?php echo e(__('Add Values')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form action="<?php echo e(route('custom-fields.value.add',$custom_field->id)); ?>" class="create-form form-horizontal" enctype="multipart/form-data" method="POST" data-parsley-validate>
                                <?php echo csrf_field(); ?>
                                <div class="col-md-12 form-group mandatory">
                                    <label for="values" class="mandatory form-label"><?php echo e(__('Field Values')); ?></label>
                                    <input type="text" name="values" id="values" class="form-control" value="<?php echo e(old('values')); ?>" data-parsley-required="true">
                                </div>

                                <input type="hidden" name="field_id" id="field_id" value="<?php echo e($custom_field->id); ?>">
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(__('Save')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- /.modal-content -->
            </div>
            
            <div id="editModal" class="modal fade" tabindex="-1" role="dialog" aria-labelledby="myModalLabel1" aria-hidden="true">
                <div class="modal-dialog">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel1"><?php echo e(__('Edit Custome Field Values')); ?></h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            <form action="<?php echo e(route('custom-fields.value.update',$custom_field->id)); ?>" class="edit-form form-horizontal" enctype="multipart/form-data" method="POST" data-parsley-validate>
                                <?php echo csrf_field(); ?>
                                <input type="hidden" name="old_custom_field_value" id="old_custom_field_value"/>
                                <div class="col-md-12 form-group mandatory">
                                    <label for="new_custom_field_value" class="mandatory form-label"><?php echo e(__('Name')); ?></label>
                                    <input type="text" name="new_custom_field_value" id="new_custom_field_value" class="form-control" value="" data-parsley-required="true">
                                </div>
                                <div class="modal-footer">
                                    <button type="button" class="btn btn-secondary waves-effect" data-bs-dismiss="modal"><?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="btn btn-primary waves-effect waves-light"><?php echo e(__('Save')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- /.modal-content -->
                <?php endif; ?>
            </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        function afterCustomFieldUpdate() {
            setTimeout(function () {
                window.location.href = "<?php echo e(route('custom-fields.index')); ?>"
            }, 1000)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/custom-fields/edit.blade.php ENDPATH**/ ?>