

<?php $__env->startSection('title'); ?>
    <?php echo e(__("Custom Fields")); ?> / <?php echo e(__("Sub Category")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="row">
            <div class="col-md-10">
                <div class="buttons text-start">
                    <a href="<?php echo e(route('category.index', $p_id)); ?>" class="btn btn-primary">< <?php echo e(__("Back To Category")); ?> </a>
                    <a href="<?php echo e(route('custom-fields.create', ['id' => $cat_id])); ?>" class="btn btn-primary">+ <?php echo e(__("Create Custom Field")); ?> / <?php echo e($category_name); ?></a>
                </div>
            </div>
        </div>

        <div class="col-md-12 col-sm-12">
            <div class="card">
                <div class="card-body">
                    <table class="table table-borderless table-striped" aria-describedby="mydesc" id="table_list"
                           data-toggle="table" data-url="<?php echo e(route('category.custom-fields.show', $cat_id)); ?>"
                           data-click-to-select="true" data-side-pagination="server" data-pagination="true"
                           data-page-list="[5, 10, 20, 50, 100, 200]" data-search="true" data-search-align="right"
                           data-escape="true"
                           data-toolbar="#toolbar" data-show-columns="true" data-show-refresh="true" data-fixed-columns="true"
                           data-fixed-number="1" data-fixed-right-number="1" data-trim-on-search="false" data-responsive="true"
                           data-sort-name="id" data-sort-order="desc" data-pagination-successively-size="3"
                           data-query-params="queryParams" data-mobile-responsive="true">
                        <thead class="thead-dark">
                        <tr>
                            <th scope="col" data-field="state" data-checkbox="true"></th>
                            <th scope="col" data-field="id" data-align="center" data-sortable="true"><?php echo e(__('ID')); ?></th>
                            <th scope="col" data-field="image" data-align="center" data-formatter='imageFormatter'><?php echo e(__('Image')); ?></th>
                            <th scope="col" data-field="name" data-align="center" data-sortable="true"><?php echo e(__('Custom Field')); ?></th>
                            <th scope="col" data-field="operate" data-escape="false" data-sortable="false"><?php echo e(__('Action')); ?></th>
                        </tr>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/category/custom-fields.blade.php ENDPATH**/ ?>