
<?php $__env->startSection('title'); ?>
    <?php echo e(__("Edit Tips")); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <div class="buttons">
            <a class="btn btn-primary" href="<?php echo e(route('tips.index')); ?>">< <?php echo e(__("Back to All Tips")); ?> </a>
        </div>
        <div class="row">
            <form class="form-redirection" action="<?php echo e(route('tips.update',$tip->id)); ?>" method="POST" data-parsley-validate enctype="multipart/form-data" data-success-function="successFunction">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="_method" value="PUT">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header"><?php echo e(__("Edit Tips")); ?></div>

                        <div class="card-body mt-3">
                            <div class="row">
                                <div class="col-md-12 form-group mandatory">
                                    <label for="description" class="form-label"><?php echo e(__('Description')); ?></label>
                                    <textarea name="description" id="description" class="form-control" cols="10" rows="5" required><?php echo e($tip->description); ?></textarea>
                                </div>
                            </div>

                            <?php if($languages->isNotEmpty()): ?>
                                <hr>
                                <h5><?php echo e(__("Translation")); ?></h5>
                                <div class="row">
                                    <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <hr>
                                        <h5><?php echo e(($key+1).". ".$language->name); ?></h5>
                                        <div class="col-md-12 form-group">
                                            <label for="description" class="form-label"><?php echo e(__('Description')); ?> : </label>
                                            <textarea name="translations[<?php echo e($language->id); ?>]" id="description" class="form-control" cols="10" rows="5" required><?php echo e($translations[$language->id]??''); ?></textarea>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="col-md-12 text-end">
                        <input type="submit" class="btn btn-primary" value="<?php echo e(__("Save and Back")); ?>">
                    </div>
                </div>
            </form>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        function successFunction() {
            setTimeout(function () {
                window.location.href = "<?php echo e(route('tips.index')); ?>";
            }, 1000)
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/tip/edit.blade.php ENDPATH**/ ?>