

<?php $__env->startSection('title'); ?>
    <?php echo e(__('Web Settings')); ?>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-title'); ?>
    <div class="page-title">
        <div class="row">
            <div class="col-12 col-md-6 order-md-1 order-last">
                <h4><?php echo $__env->yieldContent('title'); ?></h4>
            </div>
            <div class="col-12 col-md-6 order-md-2 order-first"></div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <section class="section">
        <form class="create-form-without-reset" action="<?php echo e(route('settings.store')); ?>" method="post" enctype="multipart/form-data" data-success-function="successFunction" data-parsley-validate>
            <?php echo csrf_field(); ?>
            <div class="row d-flex mb-3">
            <div class="card">
                <div class="card-body">
                    <div class="divider pt-3">
                        <h6 class="divider-text"><?php echo e(__('Web Settings')); ?></h6>
                    </div>
                    <div class="row">
                        <div class="form-group col-md-6 col-sm-12">
                            <label for="web_theme_color" class="form-label "><?php echo e(__('Theme Color')); ?></label>
                            <input id="web_theme_color" name="web_theme_color" type="color" class="form-control form-control-color" placeholder="<?php echo e(__('Theme Color')); ?>" value="<?php echo e($settings['web_theme_color'] ?? ''); ?>">
                        </div>

                        <div class="form-group col-md-6 col-sm-12">
                            <label for="place_api_key" class="form-label "><?php echo e(__('Place API Key')); ?></label>
                            <input class="form-control" type="text" name="place_api_key" id="place_api_key" value="<?php echo e($settings['place_api_key'] ?? ''); ?>">
                        </div>

                        <div class="form-group col-md-6 col-sm-12">
                            <label class="form-label "><?php echo e(__('Header Logo')); ?></label>
                            <input class="filepond" type="file" name="header_logo" id="header_logo">
                            <img src="<?php echo e($settings['header_logo'] ?? ''); ?>" data-custom-image="<?php echo e(asset('assets/images/logo/Header Logo.svg')); ?>" class="w-25" alt="image">
                        </div>

                        <div class="form-group col-md-6 col-sm-12">
                            <label class="form-label "><?php echo e(__('Footer Logo')); ?></label>
                            <input class="filepond" type="file" name="footer_logo" id="footer_logo">
                            <img src="<?php echo e($settings['footer_logo'] ?? ''); ?>" data-custom-image="<?php echo e(asset('assets/images/logo/Footer Logo.svg')); ?>" class="w-25" alt="image">
                        </div>

                        <div class="form-group col-md-6 col-sm-12">
                            <label class="form-label "><?php echo e(__('Placeholder image')); ?> <small><?php echo e(__('(This image will be displayed if no image is available.)')); ?></small></label>
                            <input class="filepond" type="file" name="placeholder_image" id="placeholder_image">
                            <img src="<?php echo e($settings['placeholder_image'] ?? ''); ?>" data-custom-image="<?php echo e(asset('assets/images/logo/favicon.png')); ?>" alt="image" style="height: 31%;width: 21%;">
                        </div>


                        <div class="form-group col-md-6 col-sm-12">
                            <label for="footer_description" class="form-label "><?php echo e(__('Footer Description')); ?></label>
                            <textarea id="footer_description" name="footer_description" class="form-control" rows="5" placeholder="<?php echo e(__('Footer Description')); ?>"><?php echo e($settings['footer_description'] ?? ''); ?></textarea>
                        </div>

                        <div class="form-group col-md-6 col-sm-12">
                            <label for="google_map_iframe_link" class="form-label "><?php echo e(__('Google Map Iframe Link')); ?></label>
                            <textarea id="google_map_iframe_link" name="google_map_iframe_link" type="text" class="form-control" rows="5" placeholder="<?php echo e(__('Google Map Iframe Link')); ?>"><?php echo e($settings['google_map_iframe_link'] ?? ''); ?></textarea>
                        </div>

                        <div class="form-group col-md-6 col-sm-12">
                            <label for="google_map_iframe_link" class="form-label "><?php echo e(__('Default Latitude & Longitude')); ?> <small><?php echo e(__('(For Default Location Selection)')); ?></small></label>
                            <div class="form-group">
                                <label for="default_latitude" class="form-label "><?php echo e(__('Latitude')); ?></label>
                                <input id="default_latitude" name="default_latitude" type="text" class="form-control" placeholder="<?php echo e(__('Latitude')); ?>" value="<?php echo e($settings['default_latitude'] ?? ''); ?>">
                                <label for="default_longitude" class="form-label "><?php echo e(__('Longitude')); ?></label>
                                <input id="default_longitude" name="default_longitude" type="text" class="form-control" placeholder="<?php echo e(__('Longitude')); ?>" value="<?php echo e($settings['default_longitude'] ?? ''); ?>">
                            </div>
                        </div>

                        <div class="form-group col-md-6 col-sm-12">
                            <label class="form-label"><?php echo e(__('Show Landing Page')); ?></label>
                            <div class="form-check form-switch">
                                <input type="hidden" name="show_landing_page" value="0">
                                <input class="form-check-input" type="checkbox" id="show_landing_page" name="show_landing_page" value="1" <?php echo e(isset($settings['show_landing_page']) && $settings['show_landing_page'] == 1 ? 'checked' : ''); ?>>
                                <label class="form-check-label" for="show_landing_page">
                                    <?php echo e(__('On / Off')); ?>

                                </label>
                            </div>
                        </div>
                   

                    <div class="divider pt-3">
                        <h6 class="divider-text"><?php echo e(__('Social Media Links')); ?></h6>
                    </div>
                    <div class="form-group col-sm-12 col-md-4">
                        <label for="instagram_link" class="form-label "><?php echo e(__('Instagram Link')); ?></label>
                        <input id="instagram_link" name="instagram_link" type="url" class="form-control" placeholder="<?php echo e(__('Instagram Link')); ?>" value="<?php echo e($settings['instagram_link'] ?? ''); ?>">
                    </div>
                    <div class="form-group col-sm-12 col-md-4">
                        <label for="x_link" class="form-label "><?php echo e(__('X Link')); ?></label>
                        <input id="x_link" name="x_link" type="url" class="form-control" placeholder="<?php echo e(__('X Link')); ?>" value="<?php echo e($settings['x_link'] ?? ''); ?>">
                    </div>
                    <div class="form-group col-sm-12 col-md-4">
                        <label for="facebook_link" class="form-label "><?php echo e(__('Facebook Link')); ?></label>
                        <input id="facebook_link" name="facebook_link" type="url" class="form-control" placeholder="<?php echo e(__('Facebook Link')); ?>" value="<?php echo e($settings['facebook_link'] ?? ''); ?>">
                    </div>
                    <div class="form-group col-sm-12 col-md-4">
                        <label for="linkedin_link" class="form-label "><?php echo e(__('Linkedin Link')); ?></label>
                        <input id="linkedin_link" name="linkedin_link" type="url" class="form-control" placeholder="<?php echo e(__('Linkedin Link')); ?>" value="<?php echo e($settings['linkedin_link'] ?? ''); ?>">
                    </div>
                    <div class="form-group col-sm-12 col-md-4">
                        <label for="pinterest_link" class="form-label "><?php echo e(__('Pinterest Link')); ?></label>
                        <input id="pinterest_link" name="pinterest_link" type="url" class="form-control" placeholder="<?php echo e(__('Pinterest Link')); ?>" value="<?php echo e($settings['pinterest_link'] ?? ''); ?>">
                    </div>
                </div>
                </div>
            </div>
            <div class="col-12 d-flex justify-content-end">
                <button type="submit" value="btnAdd" class="btn btn-primary me-1 mb-3"><?php echo e(__('Save')); ?></button>
            </div>
        </form>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('js'); ?>
    <script>
        function successFunction() {
            window.location.reload();
        }
    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\eclassify-devlopment\eClassify\resources\views/settings/web-settings.blade.php ENDPATH**/ ?>